import styled from 'styled-components'

// import logo from '@/assets/images/logo.png'
import { useAppSelector } from '@/hooks/useStore'

const Logo = () => {
  const isCollapse = useAppSelector(state => state.menu.isCollapse)
  return (
    <LogoWrap className="logo-box">
      {/* <img src={logo} alt="logo" className="logo-img" /> */}
      {!isCollapse ? <h2 className="logo-text">配置管理平台</h2> : null}
    </LogoWrap>
  )
}

const LogoWrap = styled.div`
  display: flex;
  align-items: center;
  justify-content: center;
  height: 55px;
  border-bottom: 1px solid #e5e6eb;
  .logo-img {
    width: 30px;
    margin: 0;
  }
  .logo-text {
    margin: 0 0 0 10px;
    font-size: 20px;
    font-weight: 500;
    color: #1d2129;
    font-family: PingFang SC;
    white-space: nowrap;
  }
`

export default Logo
