import ReactDOM from 'react-dom/client'
/**
 * React Router
 * */
import { Provider } from 'react-redux'
import { BrowserRouter } from 'react-router-dom'

import dayjs from 'dayjs'
import { PersistGate } from 'redux-persist/integration/react'

import { ConfigProvider } from 'antd'
import zhCN from 'antd/lib/locale/zh_CN'

import { store, persistor } from '@/store'

import Routes from './router'
import AuthRouter from './router/AuthRouter'

import 'dayjs/locale/zh-cn'
dayjs.locale('zh-cn')

const ROOT = document.getElementById('root')

const App = () => (
  // <React.StrictMode>
  <Provider store={store}>
    <PersistGate loading={null} persistor={persistor}>
      <BrowserRouter>
        <ConfigProvider locale={zhCN} componentSize="middle" input={{ autoComplete: 'off' }}>
          <AuthRouter>
            <Routes />
          </AuthRouter>
        </ConfigProvider>
      </BrowserRouter>
    </PersistGate>
  </Provider>
  // </React.StrictMode>
)
ROOT && ReactDOM.createRoot(ROOT).render(<App />)
