import React from 'react'

import { ModalForm, ProFormText } from '@ant-design/pro-form'

import { message } from 'antd'

import { TAccountNumUpdate } from '@/typings/account-num'

import { PasswordUpdateApi } from '../common/services'

type TProps = {
  visible: boolean;
  id: number;
  handleUpdatePassword: (values: boolean) => void;
};

const AddAccount = ({ visible, id, handleUpdatePassword }: TProps) => {
  const title = '修改密码'

  const cancelClick = () => {
    handleUpdatePassword(false)
  }
  const okClick = async (data: any) => {
    const param = {
      userId: id,
      newPassword: data?.newPassword,
      password: data?.password
    }
    try {
      const { code } = await PasswordUpdateApi(param)
      if (code === 0) {
        message.success('修改成功')
        handleUpdatePassword(false)
      } else {
        message.error('修改失败')
      }
    } catch (error) {
      console.log(error)
    }
  }
  return (
    <ModalForm<TAccountNumUpdate>
      title={title}
      visible={visible}
      autoFocusFirstInput
      modalProps={{
        onCancel: cancelClick,
        destroyOnClose: true
      }}
      onFinish={async (e) => {
        okClick(e)
      }}
      layout="horizontal"
    >
      <ProFormText
        width="md"
        name="password"
        label="原密码"
        placeholder="请输入账号"
        rules={[{ required: true, message: '请输入原密码' }]}
      />
      <ProFormText
        width="md"
        name="newPassword"
        label="新密码"
        placeholder="请输入账号"
        rules={[{ required: true, message: '请输入新密码' }]}
      />
    </ModalForm>
  )
}
export default AddAccount
