
import { useState, useEffect, useCallback } from 'react'

import { ModalForm, ProFormText, ProFormTextArea } from '@ant-design/pro-form'

import { message } from 'antd'

import { GetDetailApi, UpdateApi, AddApi } from '../common/services'

type TProps = {
  visible: boolean,
  id: number,
  handleUpdateVisible: (value:boolean, type: string) => void
}
const AddUpdate = ({ id, visible, handleUpdateVisible }:TProps) => {
  const [title, setTitle] = useState<string>('')

  useEffect(() => {
    setTitle(() => {
      return id ? '编辑演播室' : '创建演播室'
    })
  }, [visible])
  const fetchDetail = useCallback(async () => {
    let data:any = {
      studioName: '', // 演播室名称
      studioId: '', // 演播室id
      ip1: '', // 主服务ip
      ip2: '', // 备服务ip
      port1: '', // 主服务器端口
      port2: '', // 备服务器端口
      sceneNameS: '', // 主场景地址
      sceneNameQ: '', // 备场景地址
      createTime: '', // 创建时间
      updateTime: '', // 修改时间
      type: '', // 弹幕类型
      intervalTime: 3, // 弹幕轮询时间间隔
      bulletChatNums: 0, // 筛选弹幕限制数量
      powerTime: 3 // 发电时刻开启服务时，默认时间间隔
    }
    if (id) {
      try {
        const res = await GetDetailApi(id)
        if (res.status !== 200) return
        data = res?.data
      } catch (error) {
        console.log(error)
      }
    }
    return data
  }, [id])
  const cnacelClick = () => {
    handleUpdateVisible(false, '')
  }
  const okClick = async (values:any) => {
    const params:any = {}
    try {
      if (id) {
        params.id = id
      }
      console.log('params===>', params)
      const { status } = id ? await UpdateApi(params) : await AddApi(params)
      if (status === 200) {
        id ? message.success('编辑成功') : message.success('创建成功')
        handleUpdateVisible(false, 'add')
      }
    } catch (error) {
      console.log(error)
    }
  }

  return (
    <ModalForm
    title={title}
    visible={visible}
    autoFocusFirstInput
    modalProps={{
      onCancel: cnacelClick,
      destroyOnClose: true
    }}
    onFinish={async (e) => {
      okClick(e)
    }}
    request={fetchDetail}>
      <ProFormText width="md" name="studioName" label="模块名称" placeholder="请输入模块名称" />
      <ProFormTextArea width="lg" name="studioId" label="模块描述" placeholder="请输入描述内容" />
    </ModalForm>
  )
}
export default AddUpdate
