import { Get, Post } from '@/utils/request'

import { TDelete, TMatchList, TMatchUpdate } from './typing'

/**
 * @description 列表查询
 */
export const GetListByPageApi = (params: TMatchList): Promise<any> => {
  return Post('type/getGameTypeList', { params })
}
/**
 * @description 删除
 */
export const DelApi = (params:Partial<TDelete>): Promise<any> => {
  return Get('/type/deleteGameType', { params })
}
/**
 * @description 修改
 */
export const UpdateApi = (params: Partial<TMatchUpdate>): Promise<any> => {
  return Post('/type/updateGameType', { params })
}
/**
 * @description 添加
 */
export const AddApi = (params: Partial<TMatchUpdate>): Promise<any> => {
  return Post('/type/insertGameType', { params })
}
/**
 * @description 获取所有演播室/互动数据
 */
export const getStudiosModels = (): Promise<any> => {
  return Get('/type/getAllStudiosGameType')
}
/**
// /**
//  * @description 详情
//  */
// export const GetDetailApi = (id: number): Promise<any> => {
//   return Get(`/hzy-admin/sys/user/${id}`)
// }
