
import { ProFormText, ProFormTextArea, ProFormTreeSelect } from '@ant-design/pro-form'

import { useAppSelector } from '@/hooks/useStore'

type Tprops = {
  status: boolean
}
const DForm = ({ status }: Tprops) => {
  const { files, studios, models } = useAppSelector(({ match }) => (match))

  return (
    <>
      <ProFormText disabled={status} width="md" name="name" label="赛事名称" placeholder="请输入赛事名称" rules={[{ required: true, message: '请输入赛事名称' }]}/>
      <ProFormTextArea disabled={status} width="xl" name="info" label="赛事说明" placeholder="请输入赛事说明" />
      <ProFormTreeSelect
        disabled={status}
        name="studioList"
        label="关联演播室"
        placeholder="请选择演播室"
        allowClear
        width="lg"
        secondary
        fieldProps={files}
        request={async () => { return studios }}
        rules={[{ required: true, message: '请关联演播室' }]}
      />
      <ProFormTreeSelect
        disabled={status}
        name="modelsList"
        label="关联互动模块"
        placeholder="请选择互动模块"
        allowClear
        width="lg"
        secondary
        fieldProps={files}
        request={async () => { return models }}
        rules={[{ required: true, message: '请关联互动模块' }]}
      /></>
  )
}
export default DForm
