
import { useCallback, useEffect, useState } from 'react'

import { ModalForm } from '@ant-design/pro-form'

import { message } from 'antd'

import { AddApi, GetListByPageApi, UpdateApi } from '../common/services'
import DForm from './DForm'

type TProps = {
  visible: boolean,
  id: number,
  handleUpdateVisible: (value:boolean, type: string) => void
}
const AddUpdate = ({ id, visible, handleUpdateVisible }:TProps) => {
  const [title, setTitle] = useState<string>('')
  useEffect(() => {
    setTitle(() => {
      return id ? '编辑赛事' : '创建赛事'
    })
  }, [visible])
  const fetchDetail = useCallback(async () => {
    let data:any = {
      name: '',
      info: '',
      studioList: [],
      modelsList: []
    }
    if (id) {
      try {
        const res = await GetListByPageApi({
          id,
          pageBean: {
            pageNum: 0,
            pageSize: 0
          }
        })
        if (res.status !== 200) return
        data = res?.data?.list[0]
      } catch (error) {
        console.log(error)
      }
    }
    return data
  }, [id])
  const cnacelClick = () => {
    handleUpdateVisible(false, '')
  }
  const okClick = async (values:any) => {
    console.log(values, 9999)
    const params:any = {
      name: values.name,
      info: values.info,
      studioList: values.studioList,
      modelsList: values.modelsList
    }
    try {
      if (id) {
        params.id = id
      }
      console.log('params===>', params)
      const { status } = id ? await UpdateApi(params) : await AddApi(params)
      if (status === 200) {
        id ? message.success('编辑成功') : message.success('创建成功')
        handleUpdateVisible(false, 'add')
      }
    } catch (error) {
      console.log(error)
    }
  }

  return (
    <ModalForm
    title={title}
    visible={visible}
    autoFocusFirstInput
    modalProps={{
      onCancel: cnacelClick,
      destroyOnClose: true
    }}
    onFinish={async (e) => {
      okClick(e)
    }}
    request={fetchDetail}
    >
      <DForm status={false}/>
    </ModalForm>
  )
}
export default AddUpdate
