import { createAsyncThunk, createSlice } from '@reduxjs/toolkit'

import { getStudiosModels } from '../common/services'

// import { GetListByPageApi } from '../common/services'

type TMatch = {
  data: string
  files: object
  studios: Array<any> // 演播室数组
  models: Array<any> // 互动模块数组
}
const initialState: TMatch = {
  data: '',
  files: { // TreeSelect组件配置项
    showArrow: false,
    filterTreeNode: true,
    showSearch: true,
    dropdownMatchSelectWidth: false,
    labelInValue: true,
    autoClearSearchValue: true,
    multiple: true,
    treeNodeFilterProp: 'label',
    fieldNames: {
      label: 'label'
    }
  },
  studios: [], // 演播室数组
  models: [] // 互动模块数组
}
export const getStudioModels = createAsyncThunk('studios', async () => {
  const { data } = await getStudiosModels()
  return data
})

export const { reducer: matchReducer, actions } = createSlice({
  name: 'match',
  initialState,
  reducers: {
    setMenus: (state, { payload: any }) => { }
  },
  extraReducers: {
    [getStudioModels.pending.type] () { },
    [getStudioModels.rejected.type] () { },
    [getStudioModels.fulfilled.type] (state, { payload }) {
      console.log('获取演播室互动', payload)
      state.studios = payload.studios
      state.models = payload.models
    }
  }
})
export default matchReducer
