import React, { useCallback, useEffect, useMemo, useRef, useState } from 'react'

import { ProCard, ProForm, ProFormInstance } from '@ant-design/pro-components'
import styled from 'styled-components'

import { Button, message } from 'antd'

import { DelApi, GetListByPageApi } from './common/services'
import { TState } from './common/typing'
import AddUpdate from './components/addUpdate'
import DForm from './components/DForm'

const Studio = () => {
  const formRef = useRef<ProFormInstance>()
  const [currentId, setCurrentId] = useState<number>(NaN)
  const [tab, setTab] = useState<string>('')
  const [isModalVisible, setIsModalVisible] = useState<boolean>(false)
  const [dataSource, setDataSource] = useState<TState[]>([])

  useEffect(() => {
    getData()
  }, [])

  const getData = async () => { // 演播室数据
    setDataSource([])
    const { data } = await GetListByPageApi({
      pageBean: {
        pageNum: 0,
        pageSize: 0
      }
    })
    setTab(String(data?.list[0].id))
    setDataSource(data?.list)
  }
  const handleClickOperation = useCallback( // 操作
    async (type: 'Edit' | 'Del', record: any) => {
      switch (type) {
        case 'Edit':
          setIsModalVisible(true)
          setCurrentId(record.id)
          break
        case 'Del':
          try {
            const { status } = await DelApi({ id: record.id })
            if (status !== 200) {
              message.error('删除失败')
              return
            }
            message.success('删除成功')
            getData()
          } catch (error) {
            console.log(error)
            message.error('删除失败')
          }
          break
      }
    }, [dataSource])
  const handleUpdateVisible = (value: boolean, type: string) => { // 弹窗状态
    setIsModalVisible(value)
    type === 'Add' && getData()
    if (!value) {
      setCurrentId(NaN)
    }
  }
  const data = useMemo(() => {
    return dataSource.map((item) => <ProCard.TabPane key={String(item.id)} tab={item?.studioName}>
      <ProForm formRef={formRef}
        autoFocusFirstInput
        submitter={{
          render: (props: any, doms: any) => {
            return [
              <div key='operation'>
                <Button type="primary" className='button' onClick={() => handleClickOperation('Edit', item)}>编辑</Button>
                <Button type="primary" danger onClick={() => handleClickOperation('Del', item)}>删除</Button>
              </div>
            ]
          }
        }}
        initialValues={item}>
        <DForm status={true} />
      </ProForm>
    </ProCard.TabPane>)
  }, [dataSource])

  return (
    <Wrapper>
      <ProCard
        tabs={{
          type: 'card',
          tabPosition: 'top',
          activeKey: tab,
          onChange: (key: any) => {
            setTab(key)
          }
        }}
        extra={<Button type="primary" onClick={() => handleUpdateVisible(true, '')}>新增</Button>}
      >
        {data}
      </ProCard>
      <AddUpdate visible={isModalVisible} handleUpdateVisible={handleUpdateVisible} id={currentId} />
    </Wrapper>
  )
}
export default Studio
const Wrapper = styled.div`
  .button{
    margin-right: 10px;
  }
`
