import ProForm, { ProFormDigit, ProFormSelect, ProFormText } from '@ant-design/pro-form'
type Tprops = {
  status: boolean
}
const DForm = ({ status }: Tprops) => {
  return (
    <>
      <ProForm.Group>
        <ProFormText disabled={status} width="md" name="studioName" label="演播室名称" placeholder="请输入演播室名称"
          rules={[{ required: true, message: '请输入演播室名称' }]} />
        <ProFormDigit disabled={status} width="md" name="studioId" label="演播室id" placeholder="请输入演播室id" rules={[{ required: true, message: '请输入演播室id' }]} />
      </ProForm.Group>
      <ProForm.Group>
        <ProFormText disabled={status} width="md" name="ip1" label="主服务ip" placeholder="请输入主服务ip" rules={[{ required: true, message: '请输入主服务ip' }]} />
        <ProFormText disabled={status} width="md" name="port1" label="主服务器端口" placeholder="请输入主服务器端口" rules={[{ required: true, message: '请输入主服务器端口' }]} />
      </ProForm.Group>
      <ProForm.Group>
        <ProFormText disabled={status} width="md" name="ip2" label="备服务ip" placeholder="请输入备服务ip" />
        <ProFormText disabled={status} width="md" name="port2" label="备服务器端口" placeholder="请输入备服务器端口" />
      </ProForm.Group>
      <ProForm.Group>
        <ProFormText disabled={status} width="md" name="sceneNameS" label="主场景地址" placeholder="请输入主场景地址" rules={[{ required: true, message: '请输入主场景地址' }]} />
        <ProFormText disabled={status} width="md" name="sceneNameQ" label="备场景地址" placeholder="请输入备场景地址" />
      </ProForm.Group>
      <ProForm.Group>
        <ProFormSelect
          disabled={status}
          width="md"
          label="弹幕类型"
          name="type"
          placeholder='请选择弹幕类型'
          valueEnum={{
            1: '入库并存为txt',
            2: '只保存txt',
            3: '发送tcp并存为txt'
          }}
          rules={[{ required: true, message: '请选择弹幕类型' }]}
        />
        <ProFormDigit disabled={status} width="md" name="intervalTime" label="弹幕轮询时间间隔" addonAfter="秒" placeholder="请输入弹幕轮询时间间隔" />
      </ProForm.Group>
      <ProForm.Group>
        <ProFormSelect
          disabled={status}
          width="md"
          name="bulletChatNums"
          label="筛选弹幕限制条数"
          options={[
            { label: '6', value: 6 },
            { label: '8', value: 8 }
          ]}
          placeholder="请输入筛选弹幕限制数量"
          rules={[{ required: true, message: '请输入筛选弹幕限制条数' }]} />
        <ProFormDigit disabled={status} width="md" name="powerTime" label="发电轮询时间间隔" addonAfter="秒" placeholder="请输入发电轮询时间间隔" />
      </ProForm.Group>
    </>
  )
}
export default DForm
