
import { useCallback, useEffect, useState } from 'react'

import { ModalForm } from '@ant-design/pro-form'

import { message } from 'antd'

import { AddApi, GetListByPageApi, UpdateApi } from '../common/services'
import DForm from './DForm'

type TProps = {
  id:number,
  visible: boolean,
  handleUpdateVisible: (value:boolean, type: string) => void
}
const AddUpdate = ({ id, visible, handleUpdateVisible }:TProps) => {
  const [title, setTitle] = useState<string>('')

  useEffect(() => {
    setTitle(() => {
      return id ? '编辑演播室' : '创建演播室'
    })
  }, [visible])

  const fetchDetail = useCallback(async () => {
    let data:any = {
      studioName: '', // 演播室名称
      studioId: '', // 演播室id
      ip1: '', // 主服务ip
      ip2: '', // 备服务ip
      port1: '', // 主服务器端口
      port2: '', // 备服务器端口
      sceneNameS: '', // 主场景地址
      sceneNameQ: '', // 备场景地址
      createTime: '', // 创建时间
      updateTime: '', // 修改时间
      type: '', // 弹幕类型
      intervalTime: 3, // 弹幕轮询时间间隔
      bulletChatNums: 6, // 筛选弹幕限制数量
      powerTime: 3 // 发电时刻开启服务时，默认时间间隔
    }
    if (id) {
      try {
        const res = await GetListByPageApi({
          id,
          pageBean: {
            pageNum: 0,
            pageSize: 0
          }
        })
        if (res.status !== 200) return
        data = res?.data?.list[0]
      } catch (error) {
        console.log(error)
      }
    }
    return data
  }, [id])
  const cnacelClick = () => {
    handleUpdateVisible(false, '')
  }
  const okClick = async (values:any) => {
    const params:any = {
      studioName: values.studioName, // 演播室名称
      studioId: values.studioId, // 演播室id
      ip1: values.ip1, // 主服务ip
      ip2: values.ip2, // 备服务ip
      port1: values.port1, // 主服务器端口
      port2: values.port2, // 备服务器端口
      sceneNameS: values.sceneNameS, // 主场景地址
      sceneNameQ: values.sceneNameQ, // 备场景地址
      type: values.type, // 弹幕类型
      intervalTime: values.intervalTime, // 弹幕轮询时间间隔
      bulletChatNums: values.bulletChatNums, // 筛选弹幕限制数量
      powerTime: values.powerTime // 发电时刻开启服务时，默认时间间隔
      // config: {
      //   ip1: values.ip1, // 主服务ip
      //   ip2: values.ip2, // 备服务ip
      //   port1: values.port1, // 主服务器端口
      //   port2: values.port2 // 备服务器端口
      // }
    }
    try {
      if (id) {
        params.id = id
      }
      const { status } = id ? await UpdateApi(params) : await AddApi(params)
      if (status === 200) {
        id ? message.success('编辑成功') : message.success('创建成功')
        handleUpdateVisible(false, 'Add')
      }
    } catch (error) {
      console.log(error)
    }
  }

  return (
    <ModalForm
    title={title}
    visible={visible}
    autoFocusFirstInput
    modalProps={{
      onCancel: cnacelClick,
      destroyOnClose: true
    }}
    onFinish={async (e) => {
      okClick(e)
    }}
    request={fetchDetail}>
      <DForm status={false}/>
    </ModalForm>
  )
}
export default AddUpdate
