import { combineReducers, configureStore } from '@reduxjs/toolkit'
import { persistStore, persistReducer } from 'redux-persist'
import storage from 'redux-persist/es/storage'

// import GameReducer from '@/pages/Game/store/game'
// import RoomReducer from '@/pages/Room/store/room'

// import IconReducer from '../pages/System/Menus/store/icon'
import MatchReducer from '@/pages/Match/store/match'

import BreadcrumbReducer from './breadcrumb'
import MenuReducer from './menu'
import UserReducer from './user'

// 创建reducer(拆分reducer)
const reducer = combineReducers({
  user: UserReducer,
  menu: MenuReducer,
  breadcrumb: BreadcrumbReducer,
  match: MatchReducer
  // icon: IconReducer
  // room: RoomReducer,
  // game: GameReducer
})

// redux 持久化配置
const persistConfig = {
  key: 'redux-state',
  storage
}
const persistedReducer = persistReducer(persistConfig, reducer)

// 创建 store
const store = configureStore({
  reducer: persistedReducer,
  devTools: process.env.NODE_ENV !== 'production',
  middleware: (getDefaultMiddleware) =>
    getDefaultMiddleware({
      serializableCheck: false
    })
})

// 创建持久化 store
const persistor = persistStore(store)

export type RootState = ReturnType<typeof store.getState>

export type AppDispatch = typeof store.dispatch

export { store, persistor }
