import { createAsyncThunk, createSlice } from '@reduxjs/toolkit'

// import { MenuPerApi } from '@/layouts/Menu/services/menu'

export interface MenuState {
  isCollapse: boolean,
  menuListData: any[],
  permissionsData: any[],
  user: any,
  room: any,
  account: any,
  role:any,
  menu:any,
  schedule: any
}
const initialState: MenuState = {
  isCollapse: false,
  menuListData: [],
  permissionsData: [],
  user: {
    info1: 'sys:tbuser:page',
    info2: 'sys:tbuser:info',
    save: 'sys:tbuser:save',
    update: 'sys:tbuser:update',
    delete: 'sys:tbuser:delete'
  },
  room: {
    info1: 'sys:tbroom:page',
    info2: 'sys:tbroom:info',
    info3: 'sys:tbuser:list',
    save: 'sys:tbroom:save',
    update: 'sys:tbroom:update',
    delete: 'sys:tbroom:delete'
  },
  account: {
    info1: 'sys:user:page',
    info2: 'sys:user:info',
    save: 'sys:user:save',
    update: 'sys:user:update',
    delete: 'sys:user:delete'
  },
  role: {
    info1: 'sys:role:page',
    info2: 'sys:role:info',
    info3: 'sys:role:list',
    save: 'sys:role:save',
    update: 'sys:role:update',
    delete: 'sys:role:delete'
  },
  menu: {
    info1: 'sys:menu:list',
    info2: 'sys:menu:info',
    save: 'sys:menu:save',
    update: 'sys:menu:update',
    delete: 'sys:menu:delete'
  },
  schedule: {
    info1: 'sys:tbschedule:page',
    info2: 'sys:tbschedule:info',
    save: 'sys:tbschedule:save',
    update: 'sys:tbschedule:update',
    delete: 'sys:tbschedule:delete',

    LtInfo1: 'sys:tbapplylt:page',
    LtInfo2: 'sys:tbapplylt:info',
    LtSave: 'sys:tbapplylt:save',
    LtUpdate: 'sys:tbapplylt:update',
    LtDelete: 'sys:tbapplylt:delete',

    HxInfo1: 'sys:tbapplyxb:page',
    HxInfo2: 'sys:tbapplyxb:info',
    HxSave: 'sys:tbapplyxb:save',
    HxUpdate: 'sys:tbapplyxb:update',
    HxDelete: 'sys:tbapplyxb:delete',

    ScInfo1: 'sys:tbschedulexb:page',
    ScInfo2: 'sys:tbschedulexb:info',
    ScSave: 'sys:tbschedulexb:save',
    ScUpdate: 'sys:tbschedulexb:update',
    ScDelete: 'sys:tbschedulexb:delete'
  }
}

export const getPermissions = createAsyncThunk('permissions', async () => {
  // const { data } = await MenuPerApi()
  // const data = []
  const data:any = []
  return data
})
export const { reducer, actions } = createSlice({
  name: 'menu',
  initialState: { ...initialState },
  reducers: {
    setMenuListData: (state, { payload }: { payload: any[] }) => {
      console.log('[ setMenuListData ]', payload)
      state.menuListData = payload
    },
    setIsCollapse: (state, { payload }: { payload: boolean }) => {
      console.log('[ setIsCollapse ]', payload)
      state.isCollapse = payload
    }
  },
  extraReducers: {
    [getPermissions.pending.type] () { },
    [getPermissions.rejected.type] () { },
    [getPermissions.fulfilled.type] (state, { payload }) {
      state.permissionsData = payload
    }
  }
})
export const { setMenuListData, setIsCollapse } = actions

export default reducer
