import { createAsyncThunk, createSlice, PayloadAction } from '@reduxjs/toolkit'

import { LoginApi } from '@/pages/Login/common/services'

export const NAMESPACE_KEY = 'user'

type State = {
  status: 'idle' | 'loading' | 'succeeded' | 'failed',
  isLogin: boolean
  username: string
  password: string
  token: string
  remember: boolean
  avatar?: string
  createTime: number
  dept: string
  deptId: number
  deptList: string
  email: string
  enabled: boolean
  licenseExpired: boolean
  nickname: string
  phone: string
  roleIdList: string
  roles: string[]
  wxBinded?: false,
  userLoginInfo: {
    address: string
    device: string
    ip: string
    lastLoginTime: number
  },
  authRouter: string[]
}

const initialState: State = {
  status: 'idle',
  isLogin: false,
  username: '',
  password: '',
  token: '',
  remember: false,
  avatar: '',
  createTime: 0,
  dept: '',
  deptId: 0,
  deptList: '',
  email: '',
  enabled: false,
  licenseExpired: false,
  nickname: '',
  phone: '',
  roleIdList: '',
  roles: [],
  wxBinded: false,
  userLoginInfo: {
    address: '',
    device: '',
    ip: '',
    lastLoginTime: 0
  },
  authRouter: []
}

export const loginAsync = createAsyncThunk(`${NAMESPACE_KEY}/login`, async (payload: {
  username: string,
  password: string,
  captcha: any,
  uuid: any,
  grant_type: any,
}) => {
  const res = await LoginApi(payload)
  return res
})

const { reducer, actions } = createSlice({
  name: NAMESPACE_KEY,
  initialState,
  reducers: {
    // login(state, { payload }: PayloadAction<Partial<State>>) {
    //   Object.assign(state, payload)
    // },
    setAuthRouter (state, { payload }: PayloadAction<string[]>) {
      state.authRouter = payload
    },
    setLogin (state, { payload }: PayloadAction<any>) {
      state.token = payload?.token
      state.username = payload?.username
      state.isLogin = true
    },
    setLogout (state, { payload }: PayloadAction<string>) {
      state.token = ''
      state.isLogin = false
    }
  },
  extraReducers: {
    [loginAsync.pending.type]: (state: State) => {
      state.status = 'loading'
    },
    [loginAsync.rejected.type]: (state: State) => {
      state.status = 'failed'
    },
    [loginAsync.fulfilled.type]: (state: State, { payload }: PayloadAction<any>) => {
      const { code, data } = payload
      console.log('[ login请求 ]')
      if (code === 0) {
        const { token } = data
        console.log('token', token)
        state.isLogin = true
        state.token = token
        state.status = 'succeeded'
      } else {
        state.status = 'succeeded'
      }

      console.log('state', state)
    }
    // logout
  }
})

export const { setAuthRouter, setLogin, setLogout } = actions
export default reducer
